package cn.com.duiba.galaxy.sdk.component.rank;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.api.prize.PrizeApi;
import cn.com.duiba.galaxy.sdk.component.ComponentTypeEnum;
import cn.com.duiba.galaxy.sdk.component.checkin.dto.CheckinResult;

import java.util.List;

/**
 * @author jiaxz
 * @since 2023-01-18
 */
public class RankComponentActionDefault extends RankComponentAction {

    @Override
    public ComponentTypeEnum getType() {
        return ComponentTypeEnum.RANK;
    }

    /**
     * 查询排行榜奖项接口
     * 调用 api.doSign()
     *
     * @param context
     * @return
     */
    @Override
    @CustomRequestAction(id = "queryOptions", desc = "查询排行榜奖项接口")
    public List<PrizeApi> queryOptions(UserRequestApi context){
//        RankApi rankApi = context.getComponentApi().getRankApi();
        String phaseType = context.getHttpRequest().getParameter("phaseType");
        // 验证排行榜配置
        return null;
    }

    /**
     * 查询排行榜
     * 调用 api.doSign()
     *
     * @param context
     * @return
     */
    @Override
    @CustomRequestAction(id = "queryRanking", desc = "查询排行榜")
    public Object queryRanking(UserRequestApi context){
        String topN = context.getHttpRequest().getParameter("topN");
        String phaseType = context.getHttpRequest().getParameter("phaseType");


        return null;
    }


    /**
     * 查询当前用户排行榜信息
     * 调用 api.doSign()
     *
     * @param context
     * @return
     */
    @Override
    @CustomRequestAction(id = "queryUserRanking", desc = "查询当前用户排行榜信息")
    public CheckinResult queryUserRanking(UserRequestApi context){
        return null;
    }


    /**
     * 查询当前排行榜是否最后一期
     * 调用 api.doSign()
     *
     * @param context
     * @return
     */
    @Override
    @CustomRequestAction(id = "queryLastPhaseAction", desc = "查询当前排行榜是否最后一期")
    public CheckinResult queryLastPhaseAction(UserRequestApi context){
        return null;
    }
}
