package cn.com.duiba.galaxy.sdk.component.task;



import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.api.prize.inner.StrategyResult;


import java.util.Date;
import java.util.Map;

public interface TaskApi extends UserRequestApi {


    /**
     * 查询配置
     * @param componentId
     * @return 以code为key的结果
     */
    Map<String, TaskItemConfig> queryConfigAboutCode(String componentId);

    /**
     * 查询配置的任务列表
     *
     * @param componentId 组件id
     * @param userId 用户ID
     * @return
     */
    TaskQueryResult queryTasks(String componentId, Long userId);

    /**
     * 查询任务完成的次数
     *
     * @param componentId 玩法ID
     * @param userId 用户ID
     * @return
     */
    Map<String, Long> getTaskCompletedCount(String componentId, Long userId, Date startDate, Date endDate);


    /**
     * 完成任务
     *  请调用 api.doCompletedForCode()
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * @param componentId
     * @param userId
     * @param taskCode
     * @return
     */
    TaskResult doCompletedForCode(String componentId, Long userId, String taskCode);

    /**
     * 完成任务并发奖
     *  请调用 api.doCompletedAndSendPrizeForCode()
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * @param componentId
     * @param userId
     * @param taskCode
     * @return
     */
    TaskResult doCompletedAndSendPrizeForCode(String componentId, Long userId, String taskCode);



    /**
     * 领取奖励
     *  请调用 api.sendPrizeForCode()
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * @param componentId
     * @param userId
     * @param taskCode
     * @param prizePendingCode 待领奖code
     * @return
     */
    StrategyResult sendPrizeForCode(String componentId, Long userId, String taskCode, String prizePendingCode);

}
