package cn.com.duiba.galaxy.sdk.playway.join;


import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.playway.join.inner.JoinRecord;

import java.util.Date;
import java.util.List;

/**
 * 参与玩法API
 * 1.用户请求参与玩法的接口时，自定义代码区域可使用此API
 *
 * @author houwen
 */
public interface JoinUserRequestApi extends UserRequestApi {

    /**
     * 查询我的今日参与次数
     * ⚠️ 该处参与不单指dojoin
     *
     * @return {@link Long}
     */
    Long queryMyTodayCount();

    /**
     * 查询我连续参与的天数
     * 最多不超过100天
     *
     * @return {@link Integer}
     */
    Integer queryMyContinueDays();

    /**
     * 查询用户当前活动的所有参与次数
     *
     * @return {@link Long}
     */
    Long queryMyAllCount();

    /**
     * 查询我最近的参与记录
     *
     * @param limit 限制
     * @return {@link List}<{@link JoinRecord}>
     */
    List<JoinRecord> queryMyRecentRecord(int limit);

    /**
     * 查询我的参与记录
     *
     * @param start 开始
     * @param end   结束
     * @return {@link List}<{@link JoinRecord}>
     */
    List<JoinRecord> queryMyRecords(Date start, Date end);

    /**
     * 记录一次参与
     *
     * @return {@link Long}
     */
    Long doJoin();

    /**
     * 记录一次参与
     *
     * @param extra 扩展信息
     * @return {@link Long}
     */
    Long doJoin(String extra);
}
