/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.sdk.component.rank;

import cn.com.duiba.galaxy.common.exception.BizRuntimeException;
import cn.com.duiba.galaxy.common.message.BizError;
import cn.com.duiba.galaxy.sdk.PlatformSdkErrorEnum;
import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.api.user.inner.ConsumerExtra;
import cn.com.duiba.galaxy.sdk.component.rank.RankApi;
import cn.com.duiba.galaxy.sdk.component.rank.RankComponentAction;
import cn.com.duiba.galaxy.sdk.component.rank.RankConfigVo;
import cn.com.duiba.galaxy.sdk.component.rank.RankPeriodPrizeVo;
import cn.com.duiba.galaxy.sdk.component.rank.Ranking;
import cn.com.duiba.galaxy.sdk.component.rank.RankingVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RankComponentActionDefault
extends RankComponentAction {
    private final String componentId;

    public RankComponentActionDefault(String componentId) {
        this.componentId = componentId;
    }

    @Override
    @CustomRequestAction(id="queryRankInfo", desc="\u67e5\u8be2\u6392\u884c\u699c\u4fe1\u606f")
    public RankConfigVo queryRankInfo(UserRequestApi api) {
        Integer phaseType = api.getIntegerParameterCheckNull("phaseType");
        RankConfigVo rankConfigVo = null;
        if (phaseType.equals(0)) {
            rankConfigVo = api.getComponentApi().getRankApi().queryArchive(this.componentId);
        }
        if (phaseType.equals(-1)) {
            rankConfigVo = api.getComponentApi().getRankApi().queryPreviousArchive(this.componentId);
        }
        return rankConfigVo;
    }

    @Override
    @CustomRequestAction(id="queryRanking", desc="\u67e5\u8be2\u6392\u884c\u699c")
    public RankingVo queryRanking(UserRequestApi api) {
        RankApi rankApi = api.getComponentApi().getRankApi();
        Integer topN = api.getIntegerParameterCheckNull("topN");
        if (topN == null || topN > 500) {
            throw new BizRuntimeException((BizError)PlatformSdkErrorEnum.PARAM_ERROR);
        }
        Integer phaseType = api.getIntegerParameterCheckNull("phaseType");
        List<Ranking> topRankingN = null;
        Ranking myRanking = null;
        Integer myRankNum = null;
        if (phaseType.equals(0)) {
            topRankingN = rankApi.getCurrentTopN(this.componentId, topN);
            myRanking = rankApi.getCurrentRankInfo(this.componentId, api.getUserId());
            myRankNum = rankApi.getCurrentRanking(this.componentId, api.getUserId());
        }
        if (phaseType.equals(-1)) {
            topRankingN = rankApi.getPreviousTopN(this.componentId, topN);
            myRanking = rankApi.getPreviousRankInfo(this.componentId, api.getUserId());
            myRankNum = rankApi.getPreviousRanking(this.componentId, api.getUserId());
        }
        if (topRankingN == null || topRankingN.isEmpty()) {
            return null;
        }
        RankingVo rankingVo = new RankingVo();
        ArrayList<RankingVo.RankingInfo> list = new ArrayList<RankingVo.RankingInfo>();
        if (myRanking == null) {
            myRanking = new Ranking();
            myRanking.setUserId(api.getUserId());
        }
        topRankingN.add(0, myRanking);
        String previousType = rankApi.getPreviousType(this.componentId);
        rankingVo.setHasPreFlag(previousType != null);
        List<Long> userIds = topRankingN.stream().map(Ranking::getUserId).collect(Collectors.toList());
        List<ConsumerExtra> consumerExtras = api.getConsumerApi().listConsumerExtraByConsumerIds(userIds);
        Map consumerMap = consumerExtras.stream().collect(Collectors.toMap(ConsumerExtra::getConsumerId, Function.identity()));
        for (int i = 0; i < topRankingN.size(); ++i) {
            Ranking ranking = topRankingN.get(i);
            RankingVo.RankingInfo rankingInfo = new RankingVo.RankingInfo();
            rankingInfo.setIndex(i);
            rankingInfo.setScore(ranking.getMaxScore());
            rankingInfo.setUserId(ranking.getUserId());
            ConsumerExtra consumerExtra = (ConsumerExtra)consumerMap.get(ranking.getUserId());
            if (consumerExtra != null) {
                rankingInfo.setAvatar(consumerExtra.getAvatar());
                rankingInfo.setNickname(consumerExtra.getNickname());
            }
            list.add(rankingInfo);
        }
        RankingVo.RankingInfo rankingInfo = (RankingVo.RankingInfo)list.get(0);
        list.remove(0);
        rankingInfo.setIndex(myRankNum);
        rankingVo.setRankingInfos(list);
        rankingVo.setMyRanking(rankingInfo);
        return rankingVo;
    }

    @Override
    @CustomRequestAction(id="queryUserRanking", desc="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6392\u884c\u699c\u4fe1\u606f")
    public RankingVo.RankingInfo queryUserRanking(UserRequestApi api) {
        Integer phaseType = api.getIntegerParameterCheckNull("phaseType");
        Ranking myRanking = null;
        Integer myRank = null;
        if (phaseType.equals(0)) {
            myRanking = api.getComponentApi().getRankApi().getCurrentRankInfo(this.componentId, api.getUserId());
            myRank = api.getComponentApi().getRankApi().getCurrentRanking(this.componentId, api.getUserId());
        }
        if (phaseType.equals(-1)) {
            myRanking = api.getComponentApi().getRankApi().getPreviousRankInfo(this.componentId, api.getUserId());
            myRank = api.getComponentApi().getRankApi().getPreviousRanking(this.componentId, api.getUserId());
        }
        if (myRanking == null) {
            return null;
        }
        List<ConsumerExtra> consumerExtras = api.getConsumerApi().listConsumerExtraByConsumerIds(Collections.singletonList(api.getUserId()));
        Map consumerMap = consumerExtras.stream().collect(Collectors.toMap(ConsumerExtra::getConsumerId, Function.identity()));
        RankingVo.RankingInfo rankingVo = new RankingVo.RankingInfo();
        rankingVo.setIndex(myRank);
        rankingVo.setScore(myRanking.getMaxScore());
        rankingVo.setUserId(api.getUserId());
        ConsumerExtra consumerExtra = (ConsumerExtra)consumerMap.get(api.getUserId());
        if (consumerExtra != null) {
            rankingVo.setAvatar(consumerExtra.getAvatar());
            rankingVo.setNickname(consumerExtra.getNickname());
        }
        return rankingVo;
    }

    @Override
    @CustomRequestAction(id="queryLastPhaseAction", desc="\u67e5\u8be2\u5f53\u524d\u6392\u884c\u699c\u662f\u5426\u6700\u540e\u4e00\u671f")
    public Boolean queryLastPhaseAction(UserRequestApi api) {
        return api.getComponentApi().getRankApi().queryLastPhaseAction(this.componentId);
    }

    @Override
    @CustomRequestAction(id="queryPrizeAction", desc="\u67e5\u8be2\u4e2d\u5956\u4fe1\u606f")
    public RankPeriodPrizeVo queryPrizeAction(UserRequestApi api) {
        Integer phaseType = api.getIntegerParameterCheckNull("phaseType");
        RankApi rankApi = api.getComponentApi().getRankApi();
        RankPeriodPrizeVo rankConfigVo = null;
        String type = null;
        if (phaseType.equals(0)) {
            type = rankApi.getCurrentType(this.componentId);
        } else if (phaseType.equals(-1)) {
            type = rankApi.getPreviousType(this.componentId);
        }
        if (type == null) {
            return null;
        }
        rankConfigVo = rankApi.queryPrizeAction(this.componentId, type);
        return rankConfigVo;
    }
}

