package cn.com.duiba.galaxy.sdk;

import cn.com.duiba.galaxy.sdk.datas.EventLogData;
import cn.com.duiba.galaxy.sdk.datas.UserLogData;

import java.util.Map;

/**
 * @Description 平台日志api
 * @Date 2022/1/6
 * @Author WeiChaoChao
 */
public interface SdkLogApi {

    /**
     * 设置公共属性
     * 多次设置取key并集
     * 如果清除，先调用clearSuperProperties方法。
     * Params:
     * superProperties – 公共属性实体
     */
    void registerSuperProperties(Map<String, Object> propertiesMap);

    /**
     * 清除公共属性
     */
    void clearSuperProperties();

    /**
     * 事件日志埋点
     *
     * @param eventLogData
     */
    void track(EventLogData eventLogData);

    /**
     * 记录用户注册行为
     * User为注册后用户的基本属性。 1.User.distinctId注册后的唯一标识 2.anonymousId为注册前用户的匿名ID
     * Params:
     * user – 用户属性实体
     * anonymousId – 匿名 ID
     */
    void trackSignUp(UserLogData user, String anonymousId);

    /**
     * 设置用户属性
     *
     * @param userLogData
     */
    void profileSet(UserLogData userLogData);

    /**
     * 搜词设置用户的属性。
     * 与profileSet接口不同的是: 如果要设置的properties的key，在这个用户的profile中已经存在，则不处理，否则，新创建
     * Params:
     * user – 用户属性实体
     */
    void profileSetOnce(UserLogData user);

    /**
     * 为用户的一个或多个数值类型的属性累加一个数值。
     * 若该属性不存在，则创建它并设置默认值为0。属性取。
     * Params:
     * user – 用户属性实体
     */
    void profileIncrement(UserLogData user);

    /**
     * 为用户的一个或多个数组类型的属性追加字符串.
     * 属性取值类型必须为 java.util.List，且列表中元素的类型必须为 String
     * Params:
     * user – 用户属性实体
     */
    void profileAppend(UserLogData user);

    /**
     * 删除用户已存在的一条或者多条属性
     * Params:
     * user – 用户属性实体
     */
    void profileUnset(UserLogData user);

    /**
     * 删除用户所有属性
     * 以下三个字段必须: User.projectId User.distinctId User.isLogin
     * Params:
     * user – 用户属性实体
     */
    void profileDelete(UserLogData user);

}
