package cn.com.duiba.galaxy.sdk.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface CustomRequestAction {

    String id();

    String name();

    /**
     * 是否允许被合并到Merge接口中使用
     * <p>
     * 一般允许使用的场景：
     * 1.查询接口，没有配置上下文
     *
     * @return
     */
    boolean allowMergeRequest() default false;

    /**
     * 请求参数的类型
     * 可以在自定义Action的入参中增加此类型参数来获取
     *
     * @return
     */
    Class<?> requestClassType() default Void.class;

}
