package cn.com.duiba.galaxy.sdk.annotation;

import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 前置url配置
 * /projectx/{projectId}/{playwayId}/{actionId}.do，只需要配置/{playwayId}/{actionId}.do
 *
 * @author cengsp
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface UrlSerialAccess {

    @AliasFor("allAccess")
    String[] value() default {"/index.html"};

    /**
     * 声明前置访问url
     * 只要有一个没访问过就拦截
     */
    @AliasFor("value")
    String[] allAccess() default {"/index.html"};

    /**
     * 声明前置访问url
     * 只要有一个访问过就不拦截
     */
    String[] anyAccess() default {};

    /**
     * 拦截的文案
     */
    String msg() default "请重新进入活动";

    /**
     * 是否交给方法自己判断，默认不需要，直接抛异常
     * true-会将未访问的url放入context，context.setValue("urlSerialAccess", "url");
     */
    boolean selfHandle() default false;
}
