package cn.com.duiba.galaxy.sdk.component.answer;

import cn.com.duiba.galaxy.sdk.UserRequestContext;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerCompletedResult;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerQueryResult;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerQuestionResult;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerStartResult;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerSubmitResult;

/**
 * 答题组件玩法
 */
public abstract class AnswerComponent {

    /**
     * 查询
     * 请调用 api.query()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract AnswerQueryResult query(UserRequestContext context, AnswerApi api);

    /**
     * 开始答题
     * 请调用 api.start()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract AnswerStartResult start(UserRequestContext context, AnswerApi api);

    /**
     * 获取题目
     * 请调用 api.getQuestion()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract AnswerQuestionResult getQuestion(UserRequestContext context, AnswerApi api);

    /**
     * 提交答案
     * 请调用 api.submit()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract AnswerSubmitResult submit(UserRequestContext context, AnswerApi api);

    /**
     * 完成提交
     * 请调用 api.doCompleted()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract AnswerCompletedResult doCompleted(UserRequestContext context, AnswerApi api);

}
