package cn.com.duiba.galaxy.sdk.component.collectaward;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.component.collectaward.dto.ListAwardsDto;
import cn.com.duiba.galaxy.sdk.component.collectaward.param.DoAwardParam;
import cn.com.duiba.galaxy.sdk.component.sendprize.dto.SendPrizeResult;

/**
 * @program: projectx
 * @description: 组件化 - 收集条件出奖组件
 * @author: Simba
 * @create: 2021-05-11 16:14
 **/
public interface CollectAwardApi extends UserRequestApi {

    /**
     * 收集条件及商品列表
     *
     * @param playwayId 玩法id
     * @return
     */
    ListAwardsDto listAwards(String playwayId);

    /**
     * 发起领奖
     *
     * @param param
     * @return
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     */
    SendPrizeResult doAward(DoAwardParam param);

}

