package cn.com.duiba.galaxy.sdk.component.collectaward;

import cn.com.duiba.galaxy.sdk.UserRequestContext;
import cn.com.duiba.galaxy.sdk.component.collectaward.param.DoAwardParam;
import cn.com.duiba.galaxy.sdk.component.collectaward.vo.ListAwardsResult;
import cn.com.duiba.galaxy.sdk.component.sendprize.dto.SendPrizeResult;

/**
 * @program: projectx
 * @description: 组件化 - 收集条件出奖组件玩法
 * @author: Simba
 * @create: 2021-05-11 16:18
 **/
public abstract class CollectAwardComponent {

    /**
     * 收集条件及商品列表
     * <p>
     * {@link CollectAwardApi#listAwards(String)} (String)}
     */
    public abstract ListAwardsResult listAwards(UserRequestContext context, CollectAwardApi api);

    /**
     * 发起领奖
     * <p>
     * {@link CollectAwardApi#doAward(DoAwardParam)}
     *
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     */
    public abstract SendPrizeResult doAward(DoAwardParam param, UserRequestContext context, CollectAwardApi api);
}

