package cn.com.duiba.galaxy.sdk.component.countdown;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.component.countdown.dto.IncomeGiveDto;
import cn.com.duiba.galaxy.sdk.component.countdown.dto.IncomeReceiveDto;

/**
 * @program: projectx
 * @description: 组件化 - 倒计时组件
 * @author: Simba
 * @create: 2021-03-06 14:25
 **/
public interface CountdownApi extends UserRequestApi {

    /**
     * 启动当前用户的倒计时
     *
     * @desc 启动时间节点交由开发决定，该接口不做启动限制，活动告知平台启动，平台则生成启动记录，收益重新开始计算，
     */
    long start(String playwayId);

    /**
     * 收益发放 - 用于展示作用，未实际发放给用户
     *
     * @param playwayId
     * @return
     */
    IncomeGiveDto incomeGive(String playwayId);

    /**
     * 收益领取 - 发放给用户账户
     *
     * @param playwayId
     * @return
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     */
    IncomeReceiveDto incomeReceive(String playwayId);
}

