package cn.com.duiba.galaxy.sdk.component.counting;

import cn.com.duiba.galaxy.sdk.UserRequestApi;

import java.util.Date;

public interface CountingApi extends UserRequestApi {

    /**
     * 增加key对应longValue值，并设置失效时间
     * 如果key不存在，则insert一条longValue为0的数据，再增加offset； 否则在原值上进行增加offset，并设置默认失效时间为 January 1, 2099, 00:00:00 GMT
     *
     * @param playwayId 玩法ID
     * @param userId    用户ID
     * @param key       键
     * @param offset    增量:  offset可以为负数，表示减少
     * @return 成功/失败
     */
    boolean increase(String playwayId, String userId, String key, long offset);

    /**
     * 获取当前值
     *
     * @param playwayId 玩法ID
     * @param userId    用户ID
     * @param key       类型
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return
     */
    long getValue(String playwayId, String userId, String key, Date startDate, Date endDate);

}
