package cn.com.duiba.galaxy.sdk.component.exchange;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.component.exchange.dto.ExchangeAuthDto;
import cn.com.duiba.galaxy.sdk.component.exchange.dto.ExchangeLimitInfoDto;
import cn.com.duiba.galaxy.sdk.component.exchange.param.DoExchangeParam;
import cn.com.duiba.galaxy.sdk.component.exchange.param.ExchangeAuthParam;
import cn.com.duiba.galaxy.sdk.component.sendprize.dto.SendPrizeResult;

/**
 * @program: projectx
 * @description: 组件化 - 兑换组件
 * @author: Simba
 * @create: 2021-02-19 17:18
 **/
public interface ExchangeApi extends UserRequestApi {

    /**
     * 兑换条件及商品列表
     *
     * @param playwayId 玩法id
     * @return
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     */
    ExchangeLimitInfoDto listExchangeLimit(String playwayId);

    /**
     * 玩法下指定规则id的权限
     *
     * @param param
     * @return
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     */
    ExchangeAuthDto exchangeAuth(ExchangeAuthParam param);

    /**
     * 使用兑换玩法id及指定发奖规则id兑换
     *
     * @param param
     * @return
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     */
    SendPrizeResult doExchange(DoExchangeParam param);

}

