package cn.com.duiba.galaxy.sdk.component.exchange;

import cn.com.duiba.galaxy.sdk.UserRequestContext;
import cn.com.duiba.galaxy.sdk.component.ActionParam;
import cn.com.duiba.galaxy.sdk.component.exchange.param.DoExchangeParam;
import cn.com.duiba.galaxy.sdk.component.exchange.param.ExchangeAuthParam;
import cn.com.duiba.galaxy.sdk.component.exchange.vo.ExchangeAuthResult;
import cn.com.duiba.galaxy.sdk.component.exchange.vo.ExchangeLimitInfoResult;
import cn.com.duiba.galaxy.sdk.component.exchange.vo.ExchangeResult;

/**
 * @program: projectx
 * @description: 组件化 - 兑换组件玩法
 * @author: Simba
 * @create: 2021-02-23 18:56
 **/
public abstract class ExchangeComponent {

    /**
     * 查询该兑换组件玩法及商品列表
     * {@link ExchangeApi#listExchangeLimit(String)}
     *
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     */
    public abstract ExchangeLimitInfoResult listExchangeLimit(UserRequestContext context, ExchangeApi api);

    /**
     * 该玩法下指定商品的兑换权限
     * {@link ExchangeApi#exchangeAuth(ExchangeAuthParam)}
     *
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     */
    public abstract ExchangeAuthResult exchangeAuth(@ActionParam ExchangeAuthParam param, UserRequestContext context, ExchangeApi api);

    /**
     * 使用兑换玩法id兑换
     * {@link ExchangeApi#doExchange(DoExchangeParam)}
     *
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     */
    public abstract ExchangeResult doExchange(@ActionParam DoExchangeParam param, UserRequestContext context, ExchangeApi api);
}