package cn.com.duiba.galaxy.sdk.component.exchange.dto;


import cn.com.duiba.galaxy.sdk.component.exchange.enums.ExchangeLimitTypeEnum;

import java.util.List;

/**
 * @program: projectx
 * @description: 兑换限制信息Bo
 * @author: Simba
 * @create: 2021-02-23 17:22
 **/
public class ExchangeLimitInfoDto {

    /**
     * 限制类型
     *
     * @see ExchangeLimitTypeEnum
     */
    private int limitType;

    private List<ExchangeConditionDto> conditions;
    /**
     * 兑换限制次数
     */
    private Integer exchangeLimitCount;
    /**
     * 已兑换次数
     *
     * @desc ⚠️在兑换限制次数配置后该值有效，反之该值不做记录
     */
    private Long alreadyExchangeCount;

    public int getLimitType() {
        return limitType;
    }

    public void setLimitType(int limitType) {
        this.limitType = limitType;
    }

    public List<ExchangeConditionDto> getConditions() {
        return conditions;
    }

    public void setConditions(List<ExchangeConditionDto> conditions) {
        this.conditions = conditions;
    }

    public Integer getExchangeLimitCount() {
        return exchangeLimitCount;
    }

    public void setExchangeLimitCount(Integer exchangeLimitCount) {
        this.exchangeLimitCount = exchangeLimitCount;
    }

    public Long getAlreadyExchangeCount() {
        return alreadyExchangeCount;
    }

    public void setAlreadyExchangeCount(Long alreadyExchangeCount) {
        this.alreadyExchangeCount = alreadyExchangeCount;
    }
}

