package cn.com.duiba.galaxy.sdk.component.grade;

import cn.com.duiba.galaxy.sdk.UserRequestContext;
import cn.com.duiba.galaxy.sdk.component.base.PrizeResult;
import cn.com.duiba.galaxy.sdk.component.grade.dto.GradeConfigResult;
import cn.com.duiba.galaxy.sdk.component.grade.dto.GradeResult;

import java.util.List;

/**
 * 等级组件玩法
 */
public abstract class GradeComponent {

    /**
     * 请调用 api.queryGradeConfig()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract List<GradeConfigResult> queryGradeConfig(UserRequestContext context, GradeApi api);

    /**
     * 请调用 api.queryGrade()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract GradeResult queryGrade(UserRequestContext context, GradeApi api);

    /**
     * 请调用 api.sendPrize()
     *
     * @param gradeId 等级ID
     * @param context
     * @param api
     * @return
     */
    public abstract PrizeResult sendPrize(Integer gradeId, UserRequestContext context, GradeApi api);

}
