package cn.com.duiba.galaxy.sdk.component.inviteassist;

import cn.com.duiba.galaxy.sdk.UserRequestContext;
import cn.com.duiba.galaxy.sdk.component.inviteassist.dto.AssistParam;
import cn.com.duiba.galaxy.sdk.component.inviteassist.dto.AssistRecordResult;
import cn.com.duiba.galaxy.sdk.component.inviteassist.dto.AssistResult;
import cn.com.duiba.galaxy.sdk.component.inviteassist.dto.InviteAssistQueryParam;
import cn.com.duiba.galaxy.sdk.component.inviteassist.dto.InviteRecordResult;
import cn.com.duiba.galaxy.sdk.component.inviteassist.dto.InviteResult;
import cn.com.duiba.galaxy.sdk.utils.PageList;

/**
 * 邀请助力玩法
 */
public abstract class InviteAssistComponent {

    /**
     * 分享
     * 请调用 api.getInviteCode()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract InviteResult getInviteCode(UserRequestContext context, InviteAssistApi api);

    /**
     * 分享
     * 请调用 api.doAssist()
     * ⚠️ 请使用邀请风控 @InviteRiskControl
     *
     * @param context
     * @param api
     * @return
     */
    public abstract AssistResult doAssist(AssistParam param, UserRequestContext context, InviteAssistApi api);

    /**
     * 查询未读邀请数量
     * 请调用 api.queryNewInviteCount
     *
     * @param context
     * @param api
     * @return
     */
    public abstract int queryNewInviteCount(UserRequestContext context, InviteAssistApi api);

    /**
     * 分享查询
     * 请调用 api.queryTodayInviteRecords() or api.queryAllInviteRecords()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract PageList<InviteRecordResult> queryInviteRecords(InviteAssistQueryParam param, UserRequestContext context, InviteAssistApi api);

    /**
     * 分享查询
     * 请调用 api.queryTodayAssistRecords() or api.queryAllAssistRecords()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract PageList<AssistRecordResult> queryAssistRecords(InviteAssistQueryParam param, UserRequestContext context, InviteAssistApi api);

}
