package cn.com.duiba.galaxy.sdk.component.inviteassist;

import cn.com.duiba.galaxy.sdk.component.inviteassist.dto.InviteAssistQueryParam;
import cn.com.duiba.galaxy.sdk.component.inviteassist.dto.InviteAssistRecordResult;
import cn.com.duiba.galaxy.sdk.utils.PageList;

public interface InviteAssistTimerApi {

    /**
     * 查询所有邀请数量
     *
     * @param playwayId            玩法ID
     * @param userId               用户ID
     * @param distinctAssistUserId 是否去重助力者, 默认:false
     *                             true=去重
     *                             false=不去重
     * @return
     */
    int queryAllInviteCount(String projectId, String playwayId, String userId, Boolean distinctAssistUserId);

    /**
     * 查询邀请记录
     * <p>时间倒序
     * <p>清空新助力用户
     *
     * @param param 查询参数
     *              ⚠️ pageNum 当前页,从1开始
     * @return
     */
    PageList<InviteAssistRecordResult> queryInviteRecords(InviteAssistQueryParam param);

    /**
     * 查询所有助力数量
     *
     * @param playwayId           玩法ID
     * @param userId              用户ID
     * @param distinctShareUserId 是否去重分享者, 默认:false
     *                            true=去重
     *                            false=不去重
     * @return
     */
    int queryAllAssistCount(String projectId, String playwayId, String userId, Boolean distinctShareUserId);

    /**
     * 查询助力记录
     * <p>时间倒序
     *
     * @param param 查询参数
     *              ⚠️ pageNum 当前页,从1开始
     * @return
     */
    PageList<InviteAssistRecordResult> queryAssistRecords(InviteAssistQueryParam param);

}
