package cn.com.duiba.galaxy.sdk.component.pendingprize;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.component.pendingprize.dto.PendingResult;

/**
 * 待处理记录表
 *
 * @desc 用户发奖标识
 * <p>
 * Created by ZhangShun on 2021-04-15
 */
public interface PendingPrizeApi extends UserRequestApi {

    /**
     * 插入
     *
     * @param playwayId
     * @param userId
     * @param type
     */
    String addAndGetCode(String playwayId, String userId, String type);

    /**
     * 插入
     *
     * @param playwayId
     * @param userId
     * @param type
     * @param extra
     */
    String addAndGetCode(String playwayId, String userId, String type, String extra);

    /**
     * 插入
     *
     * @param playwayId
     * @param userId
     * @param type
     * @param extra
     */
    PendingResult add(String playwayId, String userId, String type, String extra);

    /**
     * 更新为已完成
     *
     * @return
     */
    void setCompleted(String code);

    /**
     * 是否已完成
     *
     * @return true=已完成
     */
    boolean isCompleted(String code);

    /**
     * 是否已完成
     *
     * @param playwayId
     * @param userId
     * @param type
     * @return true=已完成
     */
    boolean isCompleted(String playwayId, String userId, String type);

    /**
     * 根据类型查询
     *
     * @param playwayId
     * @param userId
     * @param type
     * @return
     */
    PendingResult getByType(String playwayId, String userId, String type);
}
