package cn.com.duiba.galaxy.sdk.component.period;

import cn.com.duiba.galaxy.sdk.UserRequestContext;
import cn.com.duiba.galaxy.sdk.component.base.PrizeResult;
import cn.com.duiba.galaxy.sdk.component.period.dto.PeriodResult;


/**
 * 有效期组件玩法
 */
public abstract class PeriodComponent {

    /**
     * 查询
     * 请调用 api.query()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract PeriodResult query(UserRequestContext context, PeriodApi api);

    /**
     * 参与
     * 请调用 api.join()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract PeriodResult join(UserRequestContext context, PeriodApi api);

    /**
     * 发奖
     * 请调用 api.sendPrize()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract PrizeResult sendPrize(UserRequestContext context, PeriodApi api);

}
