package cn.com.duiba.galaxy.sdk.component.rank.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 积分玩法排行榜-配置表
 *
 * @author ljh
 */
public class LeaderboardArchiveDto implements Serializable {

    /**
     * 主键
     */
    private Long id;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 排行榜配置表id
     */
    private Long leaderboardId;

    /**
     * 排行榜名称（开始时间yyyyMMdd格式）
     */
    private String rankingType;

    /**
     * 排行榜名称-展示用（开始时间yyyyMMdd格式）+期
     */
    private String rankingName;

    /**
     * 排行榜期次顺序
     */
    private Integer leaderboardVersion;

    /**
     * 排行榜开始时间
     */
    private Date startTime;

    /**
     * 排行榜开始参与时间
     */
    private Date startJoinTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 开奖时间
     */
    private Date opTime;

    /**
     * 实际开奖时间（手动开奖时更新）
     */
    private Date actualOpTime;

    /**
     * 1-自动开奖 2手动开奖
     */
    private Integer opWay;

    /**
     * 开奖状态
     */
    private Integer opStatus;

    /**
     * 奖项json
     */
    private String optionJson;

    /**
     * 奖项对象
     */
    private List<LeaderboardOptionDto> options;

    /**
     * 创建时间
     */
    private Date gmtCreated;

    /**
     * 更新时间
     */
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setLeaderboardId(Long leaderboardId) {
        this.leaderboardId = leaderboardId;
    }

    public Long getLeaderboardId() {
        return leaderboardId;
    }

    public void setRankingType(String rankingType) {
        this.rankingType = rankingType;
    }

    public String getRankingType() {
        return rankingType;
    }

    public void setLeaderboardVersion(Integer leaderboardVersion) {
        this.leaderboardVersion = leaderboardVersion;
    }

    public Integer getLeaderboardVersion() {
        return leaderboardVersion;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setOpTime(Date opTime) {
        this.opTime = opTime;
    }

    public Date getOpTime() {
        return opTime;
    }

    public void setActualOpTime(Date actualOpTime) {
        this.actualOpTime = actualOpTime;
    }

    public Date getActualOpTime() {
        return actualOpTime;
    }

    public Integer getOpWay() {
        return opWay;
    }

    public void setOpWay(Integer opWay) {
        this.opWay = opWay;
    }

    public void setGmtCreated(Date gmtCreated) {
        this.gmtCreated = gmtCreated;
    }

    public Date getGmtCreated() {
        return gmtCreated;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public Date getStartJoinTime() {
        return startJoinTime;
    }

    public void setStartJoinTime(Date startJoinTime) {
        this.startJoinTime = startJoinTime;
    }

    public String getRankingName() {
        return rankingName;
    }

    public void setRankingName(String rankingName) {
        this.rankingName = rankingName;
    }

    public Integer getOpStatus() {
        return opStatus;
    }

    public void setOpStatus(Integer opStatus) {
        this.opStatus = opStatus;
    }

    public String getOptionJson() {
        return optionJson;
    }

    public void setOptionJson(String optionJson) {
        this.optionJson = optionJson;
    }

    public List<LeaderboardOptionDto> getOptions() {
        return options;
    }

    public void setOptions(List<LeaderboardOptionDto> options) {
        this.options = options;
    }
}

