package cn.com.duiba.galaxy.sdk.component.share;

import cn.com.duiba.galaxy.sdk.UserRequestContext;
import cn.com.duiba.galaxy.sdk.component.base.OptionResult;
import cn.com.duiba.galaxy.sdk.component.share.dto.ShareQueryResult;
import cn.com.duiba.galaxy.sdk.component.share.dto.ShareResult;

import java.util.List;

/**
 * 分享组件玩法
 */
public abstract class ShareComponent {

    /**
     * 分享
     * 请调用 api.doShare()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract ShareResult doShare(UserRequestContext context, ShareApi api);

    /**
     * 分享查询
     * 请调用 api.queryCount()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract ShareQueryResult queryCount(UserRequestContext context, ShareApi api);

    /**
     * 分享奖品配置
     * 请调用 api.queryOptions()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract List<OptionResult> queryOptions(UserRequestContext context, ShareApi api);

}
