package cn.com.duiba.galaxy.sdk.component.team;

import cn.com.duiba.galaxy.sdk.UserRequestContext;
import cn.com.duiba.galaxy.sdk.component.team.dto.TeamInfoResult;
import cn.com.duiba.galaxy.sdk.component.team.dto.TeamJoinResult;
import cn.com.duiba.galaxy.sdk.component.team.dto.TeamMemberResult;
import cn.com.duiba.galaxy.sdk.component.team.dto.TeamQueryParam;
import cn.com.duiba.galaxy.sdk.component.team.dto.TeamResult;
import cn.com.duiba.galaxy.sdk.utils.PageList;

import java.util.List;

/**
 * 队伍组件玩法
 */
public abstract class TeamComponent {

    /**
     * 查询队伍列表
     * 调用 api.findTeams()
     *
     * @param param
     * @param context
     * @param api
     * @return
     */
    public abstract PageList<TeamInfoResult> findTeams(TeamQueryParam param, UserRequestContext context, TeamApi api);

    /**
     * 查询队员列表
     * 调用 api.findTeamMembers()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract List<TeamMemberResult> findTeamMembers(UserRequestContext context, TeamApi api);

    /**
     * 查询队伍信息
     * 调用 api.query()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract TeamInfoResult query(UserRequestContext context, TeamApi api);

    /**
     * 获取队伍码
     * 请调用 api.getTeamCode()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract TeamResult getTeamCode(UserRequestContext context, TeamApi api);

    /**
     * 加入队伍
     * 请调用 api.join()
     *
     * @param context
     * @param api
     * @return
     */
    public abstract TeamJoinResult join(UserRequestContext context, TeamApi api);
}
