package cn.com.duiba.galaxy.sdk.component.tmraward;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.component.tmraward.dto.ReceiveIncomeDto;
import cn.com.duiba.galaxy.sdk.component.tmraward.dto.ShowIncomeDto;
import cn.com.duiba.galaxy.sdk.component.tmraward.param.ReceiveIncomeParam;
import cn.com.duiba.galaxy.sdk.component.tmraward.param.StartParam;
import cn.com.duiba.galaxy.sdk.component.tmraward.vo.TmrAwardCompConfigVo;

/**
 * @program: projectx
 * @description: 明日奖励组件api
 * @author: Simba
 * @create: 2021-04-28 09:33
 **/
public interface TmrAwardApi extends UserRequestApi {


    TmrAwardCompConfigVo queryConfig(String playwayId);

    /**
     * 启动当前用户的明日奖励
     *
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     * '合并领取'状态下，当天已有启动记录的，不会继续生成新的启动记录，会追加在当天的启动记录上
     */
    Long start(StartParam param);

    /**
     * 未失效的-可领取的收益和即将领取的收益展示
     */
    ShowIncomeDto showIncome(String playwayId);

    /**
     * 领取收益
     *
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     */
    ReceiveIncomeDto receiveIncome(ReceiveIncomeParam param);

}

