package cn.com.duiba.galaxy.sdk.component.tmraward;

import cn.com.duiba.galaxy.sdk.UserRequestContext;
import cn.com.duiba.galaxy.sdk.component.ActionParam;
import cn.com.duiba.galaxy.sdk.component.tmraward.param.ReceiveIncomeParam;
import cn.com.duiba.galaxy.sdk.component.tmraward.param.StartParam;
import cn.com.duiba.galaxy.sdk.component.tmraward.vo.ReceiveIncomeResult;
import cn.com.duiba.galaxy.sdk.component.tmraward.vo.ShowIncomeResult;

/**
 * @program: projectx
 * @description: 组件化 - 明日奖励玩法
 * @author: Simba
 * @create: 2021-04-28 09:34
 **/
public abstract class TmrAwardComponent {


    /**
     * 开始
     *
     * @param param
     * @return
     */
    public abstract Long start(StartParam param, TmrAwardApi api);

    /**
     * 可领取的收益和即将领取的收益展示
     * {@link TmrAwardApi#showIncome(String)}
     */
    public abstract ShowIncomeResult showIncome(UserRequestContext context, TmrAwardApi api);

    /**
     * 领取收益
     * {@link TmrAwardApi#receiveIncome(ReceiveIncomeParam)}
     *
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     */
    public abstract ReceiveIncomeResult receiveIncome(@ActionParam ReceiveIncomeParam param, UserRequestContext context, TmrAwardApi api);
}

