package cn.com.duiba.galaxy.sdk.component.tmraward.enums;

/**
 * @program: projectx
 * @description: 明日奖励组件 - 失效时间类型枚举
 * @author: Simba
 * @create: 2021-04-27 17:29
 **/
public enum ExpireTypeEnum {

    NEXT_DAY(1, "次日"),

    AFTER_TWENTY_FOUR_HOUR(2, "24小时后"),

    NO_EXPIRE(3, "不失效"),

    DEVELOPER_DECIDE(4, "开发人员决定"),
    ;

    private int type;

    private String desc;

    ExpireTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ExpireTypeEnum toEnum(int type) {
        for (ExpireTypeEnum p : values()) {
            if (p.type == type) {
                return p;
            }
        }
        return null;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}

