package cn.com.duiba.galaxy.sdk.component.tmraward.enums;

/**
 * @program: projectx
 * @description: 明日奖励组件 - 可领取时间类型枚举
 * @author: Simba
 * @create: 2021-04-27 17:27
 **/
public enum ReceiveTimeTypeEnum {

    NEXT_DAY(1, "次日"),

    AFTER_TWENTY_FOUR_HOUR(2, "24小时后"),

    DEVELOPER_DECIDE(3, "开发人员决定"),
    ;

    private int type;

    private String desc;

    ReceiveTimeTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ReceiveTimeTypeEnum toEnum(int type) {
        for (ReceiveTimeTypeEnum p : values()) {
            if (p.type == type) {
                return p;
            }
        }
        return null;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}

