package cn.com.duiba.galaxy.sdk.component.tmraward.vo;

import cn.com.duiba.galaxy.sdk.component.tmraward.enums.ExpireTypeEnum;
import cn.com.duiba.galaxy.sdk.component.tmraward.enums.GiveTypeEnum;
import cn.com.duiba.galaxy.sdk.component.tmraward.enums.ReceiveTimeTypeEnum;
import cn.com.duiba.galaxy.sdk.component.tmraward.enums.ReceiveTypeEnum;

import java.util.Date;
import java.util.List;

/**
 * @program: projectx
 * @description: 明日奖励组件配置
 * @author: Simba
 * @create: 2021-04-27 13:45
 **/
public class TmrAwardCompConfigVo {

    /**
     * 领取方式
     *
     * @see ReceiveTypeEnum
     */
    private Integer receiveType;
    /**
     * 道具id
     */
    private String spId;
    /**
     * 领取时间类型
     *
     * @see ReceiveTimeTypeEnum
     */
    private Integer receiveTimeType;
    /**
     * 可以领取的时间
     */
    private Date canReceiveTime;
    /**
     * 失效类型
     *
     * @see ExpireTypeEnum
     */
    private Integer expireType;
    /**
     * 失效时间
     */
    private Date expireTime;
    /**
     * 奖励发放类型
     *
     * @see GiveTypeEnum
     */
    private Integer giveType;

    private List<TmrAwardExtraOptionConfig> extraOptions;

    public Integer getReceiveType() {
        return receiveType;
    }

    public void setReceiveType(Integer receiveType) {
        this.receiveType = receiveType;
    }

    public String getSpId() {
        return spId;
    }

    public void setSpId(String spId) {
        this.spId = spId;
    }

    public Integer getReceiveTimeType() {
        return receiveTimeType;
    }

    public void setReceiveTimeType(Integer receiveTimeType) {
        this.receiveTimeType = receiveTimeType;
    }

    public Date getCanReceiveTime() {
        return canReceiveTime;
    }

    public void setCanReceiveTime(Date canReceiveTime) {
        this.canReceiveTime = canReceiveTime;
    }

    public Integer getExpireType() {
        return expireType;
    }

    public void setExpireType(Integer expireType) {
        this.expireType = expireType;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getGiveType() {
        return giveType;
    }

    public void setGiveType(Integer giveType) {
        this.giveType = giveType;
    }

    public List<TmrAwardExtraOptionConfig> getExtraOptions() {
        return extraOptions;
    }

    public void setExtraOptions(List<TmrAwardExtraOptionConfig> extraOptions) {
        this.extraOptions = extraOptions;
    }
}

