package cn.com.duiba.galaxy.sdk.component.user;

import cn.com.duiba.galaxy.sdk.LimitException;

/**
 * 消耗API
 * <p>
 * 定制活动，发放金币，发放奖励，消耗金币，道具消耗，发放等场景。
 * 存在消耗发放问题：消耗了多少，出现异常时在再加去没有凭证，不是幂等操作
 * 被刷风险问题，加金币，加了多少是否波动较大没有预警
 * 消耗的场景，调用此API，API内部会保证幂等操作，以及波动过大进行预警
 */
public interface ExpendApi {

    /**
     * 增加一些
     *
     * @param bizId  商品ID or 道具ID
     * @param offset 增加的数量
     * @param max    最大限制 超过此数抛出异常
     * @return tickId 凭证ID
     */
    public String increase(String bizId, long offset, Long max) throws LimitException;

    /**
     * 减少一些
     *
     * @param bizId  商品ID or 道具ID
     * @param offset 增加的数量
     * @param min    最小限制 减少时小于此数抛出异常
     * @return tickId 凭证ID
     */
    public String decrease(String bizId, long offset, Long min) throws LimitException;

    /**
     * 查询数量
     *
     * @param bizId
     * @return
     */
    public Long getLong(String bizId);

    /**
     * 回退增加/减少的东西
     *
     * @param recordId 凭证ID
     * @return
     */
    public boolean rollback(String recordId);


}
