package cn.com.duiba.galaxy.sdk.datas;

import java.io.Serializable;


public class SMSValidateResponseDataNew implements Serializable {


    /**
     * 手机号
     */
    private String mobile;

    /**
     * 验证码
     */
    private String validateCode;

    /**
     * 短信发送是否成功
     */
    private boolean success;

    /**
     * 发送的短信的唯一id。非数字，例: 1_2739847598347，由兑吧短信服务生成
     * 发送失败的情况下，此字段为null
     */
    private String dbSmsId;

    /**
     * 发送失败的情况下的错误信息
     */
    private String errorMsg;

    /**
     * 错误码
     * {@link SMSResCodeEnum#getCode()}
     */
    private String resCode = SMSResCodeEnum.SUCCESS.getCode();

    /**
     * 滑块id
     */
    private String captchaId;

    public SMSValidateResponseDataNew() {
    }

    public SMSValidateResponseDataNew(String mobile, boolean success, String errorMsg, SMSResCodeEnum slide) {
        this.mobile = mobile;
        this.success = success;
        this.errorMsg = errorMsg;
        this.resCode = slide.getCode();
    }

    public SMSValidateResponseDataNew(String mobile, boolean success, String errorMsg, SMSResCodeEnum slide, String captchaId) {
        this.mobile = mobile;
        this.success = success;
        this.errorMsg = errorMsg;
        this.resCode = slide.getCode();
        this.captchaId = captchaId;

    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getDbSmsId() {
        return dbSmsId;
    }

    public void setDbSmsId(String dbSmsId) {
        this.dbSmsId = dbSmsId;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getValidateCode() {
        return validateCode;
    }

    public void setValidateCode(String validateCode) {
        this.validateCode = validateCode;
    }

    public String getResCode() {
        return resCode;
    }

    public void setResCode(String resCode) {
        this.resCode = resCode;
    }

    public String getCaptchaId() {
        return captchaId;
    }

    public void setCaptchaId(String captchaId) {
        this.captchaId = captchaId;
    }
}
