package cn.com.duiba.galaxy.sdk.ext;

import cn.com.duiba.galaxy.sdk.Api;


/**
 * Spring环境信息Api
 *
 * @author fangxiaorun
 * @date 2022/06/09
 */
public interface SpringEnvironmentApi extends Api {
    /**
     * 是否开发环境
     *
     * @return boolean
     */
    boolean isDevEnv();

    /**
     * 是否测试环境
     *
     * @return boolean
     */
    boolean isTestEnv();

    /**
     * 是否预发环境
     *
     * @return boolean
     */
    boolean isPreEnv();

    /**
     * 是否生产环境
     *
     * @return boolean
     */
    boolean isProdEnv();

    /**
     * 获取当前环境
     * <p>
     * 示例：
     * 生产：dev
     * 测试：test
     * 预发：pre
     * 生产：prod
     *
     * @return {@link String}
     */
    String getCurrentEnv();
}
