package cn.com.duiba.galaxy.sdk.pay.boc;

import cn.com.duiba.galaxy.sdk.pay.PayCenterBaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author zhangruofan
 * @date 2020/04/23
 */
public class BocWapPayCenterChargeRequest extends PayCenterBaseChargeRequest {
    private static final long serialVersionUID = 1160778169109131404L;
    /**
     * 客户端ip
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String ip;

    /**
     * 商品描述
     */
    @Size(max = 255, message = "商品描述超过255")
    @NotNull(message = "商品详情不能为空")
    private String goodsDetail;

    /**
     * 订单时间 yyyyMMddHHmmss
     */
    @NotNull(message = "订单时间不能为空")
    private String createDate;

    /**
     * 支付回调地址，不传则走默认
     */
    private String notifyUrl;

    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getGoodsDetail() {
        return goodsDetail;
    }

    public void setGoodsDetail(String goodsDetail) {
        this.goodsDetail = goodsDetail;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }
}
