package cn.com.duiba.galaxy.sdk.pay.ccb;

import cn.com.duiba.galaxy.sdk.dto.PayRecordDto;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 建行支付API
 *
 * @author fxr
 * @date 2020-6-30
 */
public interface CcbPayApi {

    /**
     * 创建支付
     *
     * @param request 请求
     * @return {@link CcbChargeResponse}
     */
    CcbChargeResponse createCharge(CcbChargeRequest request);


    /**
     * 建行支付结果通知
     *
     * @param map map
     * @return {@link CcbPayNotifyResp}
     * @throws BizRuntimeException 业务运行时异常
     */
    CcbPayNotifyResp orderNotify(Map<String, String> map);


    /**
     * 根据支付记录id查询支付记录
     *
     * @param id id
     * @return {@link PayRecordDto}
     */
    PayRecordDto findPayRecordById(Long id);


    /**
     * 查询用户最近一个进行中的订单
     *
     * @param userId 用户id
     * @return {@link PayRecordDto}
     */
    PayRecordDto findLastGoingOrder(String userId);

    /**
     * 查询过期未结束订单数量
     */
    int countTimeOutRecords(Date gmtCreate);

    /**
     * 分页查询过期未结束订单
     */
    List<PayRecordDto> findTimeOutRecordsPage(Date gmtCreate, int offset, int size);

    /**
     * 更新状态
     */
    int updateStatus(Long id, int newStatus, int oldStatus, String extra);
}
