package cn.com.duiba.galaxy.sdk.pay.gdhx;

import cn.com.duiba.galaxy.sdk.pay.BasePayReq;

import java.util.List;

/**
 * Description:
 * <p> 华兴银行支付-订单创建请求信息
 * date: 2022/8/22 11:02 上午
 *
 * @author huakai
 */
public class GdhxChargeRequest extends BasePayReq {
    private static final long serialVersionUID = 5607546397566095817L;

    /**
     * 交易时间
     */
    private String transTime;
    /**
     * 开发者用户ID
     */
    private String uid;
    /**
     * 商户号
     * 测试环境：5780000A0054321
     */
    private String merchantNo;
    /**
     * 订单号
     * C_项目ID_自定义
     * 总长度不超过32
     * 回调时将根据ID路由至不同活动的回调地址
     */
    private String orderNo;
    /**
     * NUMBER(22,4)
     * 运费
     */
    private String freight;
    /***
     * 脱敏客户姓名
     */
    private String consName;

    /**
     * 商品统计信息
     */
    private List<GdhxStatiInfo> infos;

    /**
     * 商品信息
     */
    private List<GdhxGoodsInfo> goodsInfos;

    public List<GdhxGoodsInfo> getGoodsInfos() {
        return goodsInfos;
    }

    public void setGoodsInfos(List<GdhxGoodsInfo> goodsInfos) {
        this.goodsInfos = goodsInfos;
    }

    public String getTransTime() {
        return transTime;
    }

    public GdhxChargeRequest setTransTime(String transTime) {
        this.transTime = transTime;
        return this;
    }

    public String getUid() {
        return uid;
    }

    public GdhxChargeRequest setUid(String uid) {
        this.uid = uid;
        return this;
    }

    public String getMerchantNo() {
        return merchantNo;
    }

    public GdhxChargeRequest setMerchantNo(String merchantNo) {
        this.merchantNo = merchantNo;
        return this;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public GdhxChargeRequest setOrderNo(String orderNo) {
        this.orderNo = orderNo;
        return this;
    }

    public String getFreight() {
        return freight;
    }

    public GdhxChargeRequest setFreight(String freight) {
        this.freight = freight;
        return this;
    }

    public String getConsName() {
        return consName;
    }

    public GdhxChargeRequest setConsName(String consName) {
        this.consName = consName;
        return this;
    }

    public List<GdhxStatiInfo> getInfos() {
        return infos;
    }

    public GdhxChargeRequest setInfos(List<GdhxStatiInfo> infos) {
        this.infos = infos;
        return this;
    }
}
