package cn.com.duiba.galaxy.sdk.pay.gdhx.enums;


import com.google.common.collect.Maps;

import java.util.Map;

/**
 *
 */
public enum GdhxRefundEnums {


    E01("01", "待支付"),
    E02("02", "退款成功"),
    E03("03", "退款失败"),
    E06("06", "订单处理中"),
    E00("00", "未知异常"),


    ;


    GdhxRefundEnums(String code, String message) {
        this.code = code;
        this.message = message;
    }

    private final String code;

    private final String message;


    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public static final Map<String, GdhxRefundEnums> MAP_ENUMS = Maps.newLinkedHashMap();

    static {
        for (GdhxRefundEnums value : values()) {
            MAP_ENUMS.put(value.getCode(), value);
        }
    }
}
