package cn.com.duiba.galaxy.sdk.pay.icbc;

import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;

import java.util.Map;

/**
 * @author xuwei
 * @date 2020/11/14
 */
public interface IcbcPayApi {

    IcbcChargeResponse createCharge(IcbcChargeRequest request);

    /**
     * 工行支付通知
     *
     * @param notifyUrl 需要对通知地址路径进行签名校验，所以要传过去
     * @param map       params
     * @return response
     */
    IcbcPayNotifyResp orderNotify(String notifyUrl, Map<String, String> map) throws BizRuntimeException;

    /**
     * 工行发起退款
     *
     * @param payRecordId
     * @return
     */
    IcbcRefundResp createRefund(Long payRecordId);

    /**
     * 工行支付结果查询
     *
     * @param id
     * @return
     */
    int queryPayStatus(Long id);
}
