/**
 * Copyright (C), 2015-2020, XXX有限公司
 * FileName: UnionPayApi
 * Author:   xcw
 * Date:     2020/12/9 15:33
 * Description: 浙江银联支付
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.com.duiba.galaxy.sdk.pay.union;

import cn.com.duiba.galaxy.sdk.UserRequestContext;
import cn.com.duiba.galaxy.sdk.pay.union.qrcode.SzQrcodeNotifyParam;
import cn.com.duiba.galaxy.sdk.pay.union.qrcode.SzQrcodeNotifyRequest;
import cn.com.duiba.galaxy.sdk.pay.union.qrcode.SzQrcodeNotifyResponse;
import cn.com.duiba.galaxy.sdk.pay.union.qrcode.SzQrcodeOrderQueryRequest;
import cn.com.duiba.galaxy.sdk.pay.union.qrcode.SzQrcodeOrderQueryResponse;
import cn.com.duiba.galaxy.sdk.pay.union.qrcode.SzQrcodePayRequest;
import cn.com.duiba.galaxy.sdk.pay.union.qrcode.SzQrcodePayResponse;

import java.util.Map;

/**
 * 〈浙江银联支付〉
 *
 * @author xcw
 * @create 2020/12/9
 * @since 1.0.0
 */
public interface UnionPayApi {


    /**
     * 银联云闪付
     *
     * @param request
     * @return
     */
    UnionChargeResponse createUnionPayCharge(UnionChargeRequest request);

    /**
     * 消费接口后台通知
     *
     * @param map
     * @return
     */
    UnionPayNotifyResp orderNotify(Map<String, String> map);

    /**
     * 银联云闪付支付状态
     *
     * @param payRecordId
     * @return
     */
    UnionPayStatus queryPayStatus(Long payRecordId);

    /**
     * 银联发起退款请求
     *
     * @param unionRefundRequest
     * @return
     */
    UnionRefundResp createRefund(UnionRefundRequest unionRefundRequest);

    UnionRefundNotifyResp refundNotify(Map<String, String> map);

    /**
     * 深圳银联-用户扫码API-预下单-生成二维码 62vip支付预下单
     *
     * @param szQrcodePayRequest 62vip活动支付请求类
     * @return 预下单响应
     */
    SzQrcodePayResponse order(SzQrcodePayRequest szQrcodePayRequest);

    /**
     * 订单支付通知
     * 用户支付-->银联-->通知到星速台活动-->活动调用参数解析/验证签名-->星速台活动业务-->处理成功后调用通知接口（通知积分商城）
     *
     * @param szQrcodeNotifyRequest pay-center支付通知接口
     * @return 响应
     */
    SzQrcodeNotifyResponse orderNotify(SzQrcodeNotifyRequest szQrcodeNotifyRequest);


    /**
     * 订单查询接口
     *
     * @param szQrcodeOrderQueryRequest 查询条件
     * @return 订单详细信息
     */
    SzQrcodeOrderQueryResponse orderQuery(SzQrcodeOrderQueryRequest szQrcodeOrderQueryRequest);


    /**
     * 参数解析以及签名验证
     *
     * @param context 请求上下文，因为projectx-sdk没有引用java.servlet.HttpRequest，所以直接引用上下文了
     * @return SzQrcodeNotifyParam: 签名正确
     */
    SzQrcodeNotifyParam signVerify(UserRequestContext context);

    /**
     * 深圳银联 62vip ybs 退款
     *
     * @param refundOrderReq
     * @return
     */
    YbsRefundResp activity62VipRefund(YbsRefundReq refundOrderReq);

    /**
     * 退款进度查询
     */
    YbsRefundQueryResponse doRefundQuery(YbsRefundQueryRequest entity);

}