package cn.com.duiba.galaxy.sdk.playway.scoring;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.dto.ActionRecordDto;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.playway.base.Ranking;
import cn.com.duiba.galaxy.sdk.playway.base.RankingUserPrizeRecord;

import java.util.List;

/**
 * 记分玩法API
 * 1.用户请求记分玩法的接口时，自定义代码区域可使用此API
 *
 * @author houwen
 */
public interface ScoringUserRequestApi extends UserRequestApi {


    /**
     * 提交分数
     *
     * @param startId 参与记录
     * @param score   提交的分数
     */
    void submitScore(long startId, int score);

    /**
     * 提交分数
     *
     * @param startId 参与记录
     * @param score   提交的分数
     */
    void submitScore(long startId, int score, String rankPlaywayId);

    /**
     * 查询我的今日参与次数
     * 游戏参与次数，只计算action=start
     *
     * @return 用户当前活动今日的参与次数
     */
    Long queryMyTodayCount();

    /**
     * 通过id查询参与记录
     *
     * @param startId 参与id
     * @return ActionRecordDto
     */
    ActionRecordDto findById(long startId);

    /**
     * 查询一次游戏提交的次数
     *
     * @param startId 参与id
     * @return 次数
     */
    int countTimes(long startId);

    /**
     * 获取前几名的排行榜信息
     *
     * @param topN 前几名
     *             不允许调用超过3000名的排名，会有性能问题
     * @return ranking 列表
     */
    List<Ranking> getTopN(int topN);

    /**
     * 获取前几名的排行榜信息
     *
     * @param rankPlaywayId 排行榜玩法ID
     * @param topN          前几名
     *                      不允许调用超过3000名的排名，会有性能问题
     * @return ranking 列表
     */
    List<Ranking> getTopN(String rankPlaywayId, int topN);


    /**
     * 获取上期排行榜当前用户信息
     * 排行榜已结束-返回最后一期
     * 排行榜未结束-返回上一期
     *
     * @return
     */
    RankingUserPrizeRecord getPreMyRank();

    /**
     * 获取上期排行榜当前用户信息
     * 排行榜已结束-返回最后一期
     * 排行榜未结束-返回上一期
     *
     * @param rankPlaywayId 排行榜玩法ID
     * @return
     */
    RankingUserPrizeRecord getPreMyRank(String rankPlaywayId);

    /**
     * 获取上期排行榜当前用户信息
     * 排行榜已结束-返回最后一期
     * 排行榜未结束-返回上一期
     *
     * @param rankPlaywayId 排行榜玩法ID
     * @return
     */
    RankingUserPrizeRecord getPreMyRank(String rankPlaywayId, String userId);


    /**
     * 获取新排行榜当前正在进行中的rankingType
     * 如果排行榜已结束，返回的是最后一期
     * 如果排行榜未开始，返回的是第一期
     *
     * @return
     * @throws BizRuntimeException
     */
    String getCurrentRankingType() throws BizRuntimeException;


    /**
     * 获取新排行榜当前正在进行中的rankingType
     * 如果排行榜已结束，返回的是最后一期
     * 如果排行榜未开始，返回的是第一期
     *
     * @param rankPlaywayId 排行榜玩法ID
     * @return
     * @throws BizRuntimeException
     */
    String getCurrentRankingType(String rankPlaywayId) throws BizRuntimeException;

    /**
     * 获取新排行榜上一期的rankingType
     *
     * @return
     * @throws BizRuntimeException
     */
    String getPrefixRankingType() throws BizRuntimeException;

    /**
     * 获取新排行榜上一期的rankingType
     *
     * @param rankPlaywayId 排行榜玩法ID
     * @return
     * @throws BizRuntimeException
     */
    String getPrefixRankingType(String rankPlaywayId) throws BizRuntimeException;

}
