package cn.com.duiba.galaxy.sdk.redacc;

import java.util.HashMap;
import java.util.Map;

public enum WithdrawLimitTypeEnum {
    FIXED(1, "固定金额"),
    MIN_THRESHOLD(2, "最低门槛"),
    NON(3, "无限制");

    private static Map<Integer, WithdrawLimitTypeEnum> codeMap = new HashMap<>();

    static {
        for (WithdrawLimitTypeEnum type : values()) {
            codeMap.put(type.getCode(), type);
        }
    }

    public static WithdrawLimitTypeEnum getByCode(Integer code) {
        return codeMap.get(code);
    }

    private Integer code;
    private String desc;

    WithdrawLimitTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
