package cn.com.duiba.galaxy.sdk.riskmddata;

import java.util.Objects;

public enum RiskPunishWayEnum {
    INTERRUPT_AND_POINT_OUT(1, "拒绝流程,文案提示");


    private Integer code;

    private String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    RiskPunishWayEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public static RiskPunishWayEnum getEnumByValue(Integer code) {
        if (Objects.isNull(code)) {
            return null;
        }
        for (RiskPunishWayEnum rse : RiskPunishWayEnum.values()) {
            if (Objects.equals(rse.getCode(), code)) {
                return rse;
            }
        }
        return null;
    }
}
