package cn.com.duiba.galaxy.sdk.utils;

import com.alibaba.fastjson.JSONObject;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.web.context.request.async.DeferredResult;

import java.util.Map;

/**
 * 异步 Http 请求类
 */
public interface HttpAsyncClient {

    /**
     * 提交一个异步get请求
     *
     * @param url      请求地址
     * @param params   请求参数
     * @param callback 异步回调函数
     */
    public void submitGet(String url, Map<String, String> params, HttpCallback callback);

    /**
     * 提交一个异步get请求
     *
     * @param url      请求地址
     * @param params   请求参数
     * @param headers  请求头
     * @param callback 异步回调函数
     */
    public void submitGet(String url, Map<String, String> params, Header[] headers, HttpCallback callback);

    /**
     * 提交一个异步post请求
     *
     * @param url      请求地址
     * @param params   请求参数
     * @param callback 异步回调函数
     */
    public void submitPost(String url, Map<String, String> params, HttpCallback callback);

    /**
     * 提交一个异步post请求
     *
     * @param url      请求地址
     * @param params   请求参数
     * @param headers  请求头
     * @param callback 异步回调函数
     */
    public void submitPost(String url, Map<String, String> params, Header[] headers, HttpCallback callback);

    /**
     * 提交一个异步post请求
     *
     * @param url
     * @param param
     * @param headers
     * @param callback
     */
    public void submitPostJson(String url, JSONObject param, Header[] headers, HttpCallback callback);


    /**
     * test
     *
     * @param request     请求的抽象，可以是httppost，也可以是httpurl
     * @param callbackRes 异步回调函数,方法的返回主回被输出给前端页面
     * @return DeferredResult：springmvc提供的基于回调的异步servlet实现,需返回该对象给controller。
     */
    public DeferredResult<String> asyncSubmitAndSyncReturn(HttpRequestBase request, HttpCallbackResponse callbackRes);

}
