package cn.com.duiba.galaxy.sdk.utils;

import cn.com.duiba.galaxy.sdk.UserRequestContext;
import org.apache.http.HttpResponse;

/**
 * 提供对异步IO请求响应数据的处理，处理生成的数据输出到客户端。
 * 特别强调：下列方法异步调用，不支持事务！！
 *
 * @author jiaxz
 * @since 2021-12-28
 */
public interface HttpCallbackResponse {
    /**
     * 处理异步请求的结果response，生成要返回给前端的数据
     * 可通过EntityUtils.toString(response.getEntity(), "UTF-8");获得响应body字符串
     *
     * @param context  上下文
     * @param response http返回的结果
     * @return 和普通活动接口返回数据一致。
     */
    public Object completed(UserRequestContext context, HttpResponse response);

    /**
     * Http请求失败回调方法，包括请求被取消、请求异常、响应状态码不为200。
     * 一般用作手动处理一些回滚逻辑，或自定义日志。若返回数据（包括null），将返回正常数据
     *
     * @param context 上下文
     * @param e       http请求异常信息
     * @return 需要响应的正常信息、或者可以抛出异常
     * @see
     */
    public Object failed(UserRequestContext context, Exception e) throws Exception;
}
