package cn.com.duiba.galaxy.sdk.utils;

import cn.com.duiba.galaxy.sdk.Api;
import cn.com.duiba.galaxy.sdk.datas.ValidateData;
import cn.com.duiba.galaxy.sdk.datas.ValidateTypeEnum;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: ValidateApi.java , v 0.1 2019-10-25 15:37 ZhouFeng Exp $
 */
public interface ValidateApi extends Api {

    /**
     * 用户提交表单(post-form)到产品应用后台，会携带一个验证码相关的参数，参数名为 NECaptchaValidate。
     * 产品应用需要将该参数传给易盾验证码后台做二次校验，以确保该次验证是有效并且是最近完成的。
     *
     * @param validate         提交二次校验的验证数据，即NECaptchaValidate值
     * @param validateTypeEnum 验证类型
     * @return 易盾二次验证的结果
     */
    ValidateData isCaptchaPass(String validate, ValidateTypeEnum validateTypeEnum);


}
