package cn.com.duiba.galaxy.sdk.annotation;

import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 方法参数为TimmerApi或其子类
 * 间隔时间必须大于1分钟
 * @author jiaxz
 */
@ActionAnnotation
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface TimerTriggerAction {

    @AliasFor(annotation = ActionAnnotation.class, value = "id")
    String id() ;

    /**
     * cron表达式
     * @return
     */
    String cron();

    /**
     * 是否允许重试
     * @return
     */
    boolean retry();

    /**
     * 定时任务描述
     * @return
     */
    @AliasFor(annotation = ActionAnnotation.class, value = "desc")
    String desc() default "";

}
