package cn.com.duiba.galaxy.sdk.base;

/**
 * 发奖规则返回数据
 *
 * @author houwen
 */
public interface StrategyResult {
    /**
     * 获取奖项ID
     *
     * @return 奖项ID
     */
    Long getOptionId();

    /**
     * option name
     * 直接通过奖品id发奖返回null
     *
     * @return 奖项名称
     */
    default String getOptionName() {
        return null;
    }

    /**
     * option url
     * 直接通过奖品id发奖返回null
     *
     * @return 奖项图片
     */
    default String getOptionImg() {
        return null;
    }

    /**
     * 获取配置的奖品ID
     *
     * @return 奖品ID
     */
    Long getPrizeId();

    /**
     * 奖品的类型
     *
     * @return 奖品类型
     */
    Integer getPrizeType();

    /**
     * 奖项的位置
     *
     * @return 位置序号
     */
    Integer getPosition();

    /**
     * 用户奖品记录ID
     *
     * @return
     */
    Long getUserRecordId();

    /**
     * 奖项跳转链接
     *
     * @return url
     */
    String getUrl();

    /**
     * 单次方法个数
     *
     * @return
     */
    default Long getSendCount() {
        return 1L;
    }

    /**
     * 获取扩展信息
     *
     * @return {@link String}
     */
    default String getExtra() {
        return null;
    }
}
