package cn.com.duiba.galaxy.sdk.emums;

import java.io.Serializable;

/**
 * @author zhangdaqing
 * @Date 2022/11/3 20:01
 **/
public enum StrategyTypeEnum implements Serializable {

    MUST("ru_must", "百分百中奖"),
    RANDOM("ru_random", "概率中奖"),
    ;

    private String ruId;
    private String desc;

    StrategyTypeEnum(String ruId, String desc) {
        this.ruId = ruId;
        this.desc = desc;
    }

    public static StrategyTypeEnum getStrategyTypeEnumByRuId(String ruId) {
        return valueOf(ruId);
    }


    public String getRuId() {
        return ruId;
    }

    public String getDesc() {
        return desc;
    }
}
