package cn.com.duiba.galaxy.sdk;

import cn.com.duiba.galaxy.sdk.apiextra.KeyValueApi;
import cn.com.duiba.galaxy.sdk.apiextra.QueryTable;
import cn.com.duiba.galaxy.sdk.apiextra.RedisApi;
import cn.com.duiba.galaxy.sdk.apiextra.UserContext;
import cn.com.duiba.galaxy.sdk.base.CreditsRecord;
import cn.com.duiba.galaxy.sdk.base.Field;
import cn.com.duiba.galaxy.sdk.base.StrategyResult;
import cn.com.duiba.galaxy.sdk.datas.PhoneAreaData;
import cn.com.duiba.galaxy.sdk.logger.BuriedPointService;
import cn.com.duiba.galaxy.sdk.params.DeductCreditsRequest;
import cn.com.duiba.galaxy.sdk.template.DistributedLock;
import cn.com.duiba.galaxy.sdk.transaction.ProjectTransactionApi;

import java.util.Date;
import java.util.Optional;

/**
 * 用户请求作用域内可使用的API
 *
 * @author xuhengfei
 */
public interface UserRequestApi extends Api {

    UserRequestContext getUserRequestContext();

    /**
     * 发起扣积分，返回扣积分票据号
     */
    String deductCredits(DeductCreditsRequest request);

    /**
     * 扣积分门票是否可用
     *
     * @param ticketNum
     * @return
     */
    boolean isCreditsTicketUsable(String ticketNum, Long credits);

    /**
     * 使用扣积分门票
     *
     * @param ticketNum 票据单号
     * @return true:验证通过 false:验证失败
     */
    boolean useCreditsTicket(String ticketNum);


    /**
     * 通过门票获取扣积分详情
     *
     * @param ticketNum 票据单号
     * @return creditsRecord
     */
    Optional<CreditsRecord> getCreditsTicket(String ticketNum);

    /**
     * 获取运营配置的变量Integer
     *
     * @param key 配置项Variable
     * @return 变量对应的int值
     */
    Integer getIntVariable(String key);

    /**
     * 获取运营配置变量String
     *
     * @param key 配置项Variable
     * @return 变量对应的String值
     */
    String getStringVariable(String key);

    /**
     * 获取运营配置变量 image类型
     *
     * @param key
     * @return
     */
    String getImageVariable(String key);

    /**
     * 获取运营配置变量Date
     *
     * @param key 配置项Variable
     * @return 变量对应的Date值
     */
    Date getDateVariable(String key);

//    /**
//     * 获取json配置项
//     * <p>
//     * 适用条件：
//     * 1、配置项，类型为json；
//     * 2、配置项，值为单个json对象（即解析为表单后仅有1行数据）；
//     * <p>
//     * 注意事项：
//     * 1、当配置项真实值解析为表单后存在多行数据时，调用此方法会抛出业务异常！若设计如此则应使用{@link UserRequestApi#getJsonArrayVariable(String, Class)}；
//     *
//     * @param key    key
//     * @param tClass tClass
//     * @return {@link T}
//     */
//    <T> T getJsonVariable(String key, Class<T> tClass);

//    /**
//     * 获取json数组配置项
//     * <p>
//     * 适用条件：
//     * 1、配置项，类型为json；
//     * 2、配置项，值为多个json对象（即jsonArray，解析为表单后存在多行数据）；
//     * <p>
//     * 注意事项：
//     * 1、当配置项真实值解析为表单后仅存在"1"行数据时，建议使用{@link UserRequestApi#getJsonVariable(String, Class)}，该方法直接返回解析列表中的唯一数据对象！
//     *
//     * @param key    key
//     * @param tClass tClass
//     * @return {@link List}<{@link T}>
//     */
//    <T> List<T> getJsonArrayVariable(String key, Class<T> tClass);

    /**
     * 使用发奖策略出奖
     *
     * @param prizeStrategyId 发奖策略ID
     * @return 奖项
     */
    //  StrategyResult strategyPrize(String prizeStrategyId);

    /**
     * 可以指定一个用户进行策略发奖
     * 注意：如果你得活动是模板活动，那么只能指定发奖规则(StrategyTypeEnum)
     * 如何获取StrategyTypeEnum？？cn.com.duiba.galaxy.sdk.ProjectApi#getEnableStrategyType
     *
     * @param userId
     * @param prizeStrategyId 发奖策略ID
     * @return 奖项
     */
    StrategyResult sendPrizeWithStrategy(String userId, String prizeStrategyId);


    /**
     * 创建一个分布式锁对象
     *
     * @param key
     * @param expireSeconds 自动失效时间
     * @return
     */
    DistributedLock newLock(String key, int expireSeconds);

    /**
     * 获取埋点方法
     *
     * @return LoggerService
     */
    BuriedPointService getLoggerService();
//
//    /**
//     * 获取平台sdk埋点api
//     * cf文档地址 http://cf.dui88.com/pages/viewpage.action?pageId=120126897
//     *
//     * @return
//     */
//    SdkLogApi getSdkLogApi();

//    /**
//     * 获取排行榜的服务接口
//     *
//     * @return
//     */
//    RankingApi getRankingApi();

//    UserRelationApi getUserRelationApi();

    UserContext getMyUserContext();

    UserContext getUserContext(Long userId);

    ProjectApi getProjectApi();

    DuibaApi getDuibaApi();

    /**
     * 获取一个QueryTable实例
     *
     * @param group 数据分组
     * @param clazz 映射类型
     * @param <T>
     * @return
     */
    <T extends Field> QueryTable<T> getTable(String group, Class<T> clazz);


    /**
     * 查询手机号归属地信息
     *
     * @param phone
     * @return
     */
    PhoneAreaData queryPhoneAreaData(String phone);

//    /**
//     * 获取通知api
//     *
//     * @return
//     */
//    NotifyApi getNotifyApi();
//
//    /**
//     * 检查是否给的字符串包含敏感词信息
//     *
//     * @param checkStr 需要检查的文本
//     */
//    SensitiveWordData checkContainSenWord(String checkStr);

    /**
     * 获取key-value存储功能API
     *
     * @return
     */
    KeyValueApi getKeyValueApi();

    /**
     * 获取事务执行API
     *
     * @return projectTransactionApi
     */
    ProjectTransactionApi getTransactionApi();

//    /**
//     * 获取QueryTableSp实例
//     *
//     * @param clazz 数据模型class对象
//     * @param <T>   数据模型类型
//     * @return 实例
//     */
//    <T> QueryTableSp<T> getQueryTableSp(Class<T> clazz);

    /**
     * 获取Redis缓存Api
     *
     * @return
     */
    RedisApi getRedisApi();

//    /**
//     * 获取发送消息的MqApi
//     *
//     * @return
//     */
//    MqApi getMqApi();
}
