package cn.com.duiba.galaxy.sdk.annotation;

import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author jiaxz
 *
 * 方法入参为HttpServletRequest、UserRequestApi或其子类
 */
@ActionAnnotation
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Inherited
public @interface CustomRequestAction {

    @AliasFor(annotation = ActionAnnotation.class)
    String id() default "default";

    @AliasFor(annotation = ActionAnnotation.class,attribute = "desc")
    String desc() default "";


}
