package cn.com.duiba.galaxy.sdk.playway.join.impl;


import cn.com.duiba.galaxy.sdk.UserRequestContext;
import cn.com.duiba.galaxy.sdk.message.UnclassifiedStatusEnum;
import cn.com.duiba.galaxy.sdk.playway.join.JoinPlayway;
import cn.com.duiba.galaxy.sdk.playway.join.JoinRecord;
import cn.com.duiba.galaxy.sdk.playway.join.JoinUserRequestApi;
import cn.com.duiba.galaxy.sdk.template.DistributedLock;
import cn.com.duiba.galaxy.sdk.utils.Conditions;
import cn.com.duiba.wolf.utils.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 参与玩法
 * copy from ProjectX
 */
@Slf4j
public abstract class JoinPlaywayImpl implements JoinPlayway {

    @Override
    public Object queryMyJoin(UserRequestContext context, JoinUserRequestApi joinUserRequestApi) {
        Long total = joinUserRequestApi.queryMyAllCount();
        Long today = joinUserRequestApi.queryMyTodayCount();

        Map<String, Object> map = new HashMap<>();
        map.put("total", total);
        map.put("today", today);

        return map;
    }

    @Override
    public Object queryMyJoinRecord(UserRequestContext context, JoinUserRequestApi joinUserRequestApi) {
        String start = context.getHttpRequest().getParameter("start");
        String end = context.getHttpRequest().getParameter("end");
        List<JoinRecord> records;
        if(StringUtils.isNotEmpty(start) && StringUtils.isNotEmpty(end)){
            Date startDate = DateUtils.getDayDate(start);
            Date endDate = DateUtils.getDayDate(end);
            records = joinUserRequestApi.queryMyRecords(startDate,endDate);
        }else{
            records = joinUserRequestApi.queryMyRecentRecord(200);
        }
        return records;
    }


    @Override
    public Object join(UserRequestContext context, JoinUserRequestApi joinUserRequestApi){
        DistributedLock lock= joinUserRequestApi.getMyUserContext().getMyLock();
        boolean get = lock.tryLock(1,50L);
        Conditions.expectTrue(get, UnclassifiedStatusEnum.LOCK_FAILD);

        try{
            return doJoin(context,joinUserRequestApi);
        }finally {
            lock.unlock();
        }

    }

    public abstract Object doJoin(UserRequestContext context, JoinUserRequestApi joinUserRequestApi);


}
