package cn.com.duiba.galaxy.sdk.annotation;

import cn.com.duiba.galaxy.sdk.emums.ProjectCycleCheckTypeEnum;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * 活动周期校验
 *
 * @author fangxiaorun
 * @date 2022/09/29
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface ProjectCycleCheck {

    /**
     * 活动周期校验类型，默认：{@link ProjectCycleCheckTypeEnum#DURING_THE_CYCLE}
     * 注意事项：
     * 1、活动周期校验不通过，平台将抛出业务异常；
     * 2、平台业务码生成规则参考：<a href="http://cf.dui88.com/pages/viewpage.action?pageId=169547378">活动平台错误码规范</a>
     * 3、该场景涉及错误码如下：
     * 1）活动未开始： P02121
     * 2）活动已结束： P02122
     *
     * @return {@link ProjectCycleCheckTypeEnum}
     */
    ProjectCycleCheckTypeEnum value() default ProjectCycleCheckTypeEnum.DURING_THE_CYCLE;
}
